#include <dos.h>
#include <math.h>

#define uchar unsigned char
#define screen_t unsigned char far *
#define palette_t unsigned char *

//////////////////////////
// clear
// clears screen to a color
#define clear(virt, col) _fmemset(virt, col, 64000)

//////////////////////////
// waittrace
// wait for vertical retrace
void waittrace(void)
{
				asm mov     dx,0x3da;
	NoVrt:	asm in      al,dx;
				asm and		al,8;
				asm jnz     NoVrt;
	NoVrt2:	asm in		al,dx;
				asm and		al,8;
				asm jz		NoVrt2;
}

//////////////////////////
// setmode
// change current graphics mode
// 	0x03 = text mode
// 	0x13 = 320x200 8 bit
void setmode(short mode)
{
	asm mov ax, mode;
	asm int 0x10;
}

//////////////////////////
// greyscale
// sets up a greyscale pallette
void greyscale(void)
{
	for (int x=0; x<256; x++)
	{
		outportb(0x3c8, x);
		outportb(0x3c9, x >> 2);
		outportb(0x3c9, x >> 2);
		outportb(0x3c9, x >> 2);
	}
}

///////////////////////////
// flip
// copies virtual buffer to screen
// 	defined as a macro for speed
#define flip(buff) _fmemcpy((unsigned char far *)0xA0000000, buff, 64000)

//////////////////////////
// setpal
// sets the color palette for the display
// 	Assumes 0->255 intensity range
void setpal(palette_t pal)
{
	int i=-1;
	for (int x=0; x<256; x++)
	{
		outportb(0x3c8, x);
		outportb(0x3c8, pal[++i]>>2);
		outportb(0x3c8, pal[++i]>>2);
		outportb(0x3c8, pal[++i]>>2);
	}
}

///////////////////////////
// rline
// draws a line of color col recursively
void rline(int x1, int y1, int x2, int y2, uchar col, screen_t virt)
{
	if (((x1>=0)&&(x2>=0))||
		 ((x1<320)&&(x2<320))||
		 ((y1>=0)&&(y2>=0))||
		 ((y1<200)&&(y2<200)))
	{
		int xx = (x1+x2) >> 1;
		int yy = (y1+y2) >> 1;
		if(((xx!=x1)||(yy!=y1)) && ((xx!=x2)||(yy!=y2)))
		{
			if ((xx>=0) && (xx<320) && (yy>=0) && (yy<200))
				virt[yy*320+xx] = col;
			rline(x1,y1,xx,yy,col,virt);
			rline(xx,yy,x2,y2,col,virt);
		}
	}
}

///////////////////////////
// pput
// sets pixel x,y to color col
#define pput(x,y,col,virt) if(((x)>=0)&&((x)<320)&&((y)>=0)&&((y)<200)) virt[(y)*320+(x)]=(col)

///////////////////////////
// circle
// draws a circle at x,y of radius r
void circle(int x, int y, int r, uchar col, screen_t virt)
{
	if (r<0) r*=-1;

	int xx=0;
	int yy=r;
	int r2 = r*r;

	while (yy>xx)
	{
		yy=sqrt(r2-xx*xx);  // the slowest part of the function
		pput(x+xx, y+yy, col, virt);
		pput(x-xx, y+yy, col, virt);
		pput(x+xx, y-yy, col, virt);
		pput(x-xx, y-yy, col, virt);
		pput(x+yy, y+xx, col, virt);
		pput(x-yy, y+xx, col, virt);
		pput(x+yy, y-xx, col, virt);
		pput(x-yy, y-xx, col, virt);
		// well.... slowest except maybe for all the checking
		++xx;
	}
}
