#include "graphics.h"
#include "3DMath.h"
#include "3DTrace.h"
#include "conio.h"
#include "mem.h"
#include "time.h"
#include "stdlib.h"
#include "stdio.h"

#define ambience 0

int debugmode = 0;

const int d_tab_size = 1157;
unsigned char dither_tab[d_tab_size];
int dither_index;

void init_dither_tab()
{
	int x;
	srand(time(NULL));
	for (x=0;x<d_tab_size;x++) dither_tab[x] = rand()%4;
	dither_index = 0;
}

void dither(screen_t virt)
{
	unsigned int i=0;
	int c;
	while (i<64000)
	{
		if(dither_tab[dither_index] > virt[i]%4)
		{
			c = ((virt[i]>>2)-1)<<2;
			if (c<0) c=0;
			virt[i] = c;
		}
	++i;
	++dither_index;
	if (dither_index==d_tab_size) dither_index = 0;
}
																																	}
unsigned char far *virt;
S3dObject **listing;
int num_objs = 3;
S3dLight myLight;



void GetContact(const SVect3d &p, const SVect3d &d, SContactInfo &contact)
{
	int i;
	SContactInfo temp;
	SVect3d reflect;
	SVect3d dtemp;

	contact.t = -1.0f;
	contact.uid = 0;
	contact.lightammount = 0.0f;
	contact.tex = NULL;
	contact.specularcol = 0;
	for (i=0; i<num_objs; i++) {
		TraceObjectFirstHit(listing[i], p, d, &temp);
		if (temp.t >= 0.0f) {
			if ((contact.t>=0.0f)&&(temp.t<contact.t)) contact = temp;
			else if (contact.t <0.0f) contact = temp;
		}
	}
	if (contact.t >= 0.0f) {
		contact.globaln = Normalize(contact.globaln);
//		float lightlen;
		SVect3d olv = myLight.pos - contact.globalp;
		SVect3d lightvect = Normalize(olv);
		float lightammount = lightvect*contact.globaln;
		if (lightammount <0) lightammount = 0;
		else {
			contact.globalp = contact.globalp + 0.00001*contact.globaln;
//			lightlen = Length(myLight.pos - contact.globalp);
			if ((contact.surface.z!=0.0f)) {
				dtemp = -Normalize(d);
				reflect = 2*(contact.globaln*dtemp)*contact.globaln - dtemp;
				reflect = Normalize(reflect);
			}
			// specular
			if (contact.surface.z!=0.0f) {
				float spec = ((-lightvect)*(-reflect));
				if (spec<0) spec = 0;
				else spec = pow(spec, 50)*contact.surface.z;
				if (spec>1) spec = 1;
				contact.specularcol = 255*spec;
			}
			// cast shadow
			for (i=0; i<num_objs; i++) {
				temp.t = TraceObjectShadow(listing[i], contact.globalp, olv);
				if ((temp.t>=0.0f)&&(temp.t<1.0f)) {
					i = num_objs;
					lightammount = 0.0f;
					contact.specularcol = 0;
				}
			}
		}
			lightammount += ambience;
		if (lightammount>1.0f) lightammount = 1.0f;
		contact.lightammount = 255.0f*lightammount;
	}
}

#define LIGHT_THRESH 40
#define SPEC_THRESH 16

void Trace2x2(const SVect3d &p, const SVect3d &d1, const SVect3d &d2,
			const SVect3d &d3, const SVect3d &d4,
			const SContactInfo &c1, const SContactInfo &c2,
			const SContactInfo &c3, const SContactInfo &c4,
			unsigned char *buff)
{
	int subdivision_needed = 0;

	if ((c1.uid!=c2.uid)||(c1.uid!=c3.uid)||(c1.uid!=c4.uid))
		subdivision_needed = 1;
	else {
		float avglight = (c1.lightammount + c2.lightammount + c3.lightammount + c4.lightammount)/4.0f;
		if (fabs(c1.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c2.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c3.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c4.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if ((c1.specularcol > SPEC_THRESH) && (c1.specularcol<250)) subdivision_needed = 1;
		else if ((c2.specularcol > SPEC_THRESH) && (c2.specularcol<250)) subdivision_needed = 1;
		else if ((c3.specularcol > SPEC_THRESH) && (c3.specularcol<250)) subdivision_needed = 1;
		else if ((c4.specularcol > SPEC_THRESH) && (c4.specularcol<250)) subdivision_needed = 1;
	}

//	subdivision_needed = 1;

	if (subdivision_needed) {
		// find d for top, bottom, left, right, and center
		SVect3d dtop = (d1+d2)/2.0f;
		SVect3d dbottom = (d3+d4)/2.0f;
		SVect3d dleft = (d1+d3)/2.0f;
		SVect3d dright = (d2+d4)/2.0f;
		SVect3d dcenter = (dleft+dright)/2.0f;
		// get contact info for each
		SContactInfo ctop, cbottom, cleft, cright, ccenter;
		GetContact(p, dtop, ctop);
		GetContact(p, dleft, cleft);
		GetContact(p, dcenter, ccenter);
		// place in buff
		unsigned int col;
		if (c1.tex != NULL) col = GetTexCol(c1.objtype, c1.localp, c1.tex);
		else col = c1.col;
		col = ((col*c1.lightammount) >> 8) + c1.specularcol;
		if (col>255) col = 255;
		buff[0] = col;

		if (ctop.tex != NULL) col = GetTexCol(ctop.objtype, ctop.localp, ctop.tex);
		else col = ctop.col;
		col = ((col*ctop.lightammount)>>8) + ctop.specularcol;
		if (col>255) col = 255;
		buff[1] = col;

		if (cleft.tex != NULL) col = GetTexCol(cleft.objtype, cleft.localp, cleft.tex);
		else col = cleft.col;
		col = ((col*cleft.lightammount)>>8) + cleft.specularcol;
		if (col>255) col = 255;
		buff[320] = col;

		if (ccenter.tex != NULL) col = GetTexCol(ccenter.objtype, ccenter.localp, ccenter.tex);
		else col = ccenter.col;
		col = ((col*ccenter.lightammount)>>8) + ccenter.specularcol;
		if (col>255) col = 255;
		buff[321] = col;

	} else {
		*buff = (c1.col*c1.lightammount) >> 8;
		if (!debugmode) {
			int x, y, ix, iy;
			SVect3d rampleft = (c3.localp-c1.localp)*0.5;
			SVect3d rampright = (c4.localp-c2.localp)*0.5;
			SVect3d ramp;
			unsigned int col;
			unsigned char leftcol, rightcol;
			unsigned char lightammount;
			unsigned char leftlight, rightlight;
			unsigned char specleft, specright, spec;
			SVect3d leftp, rightp, thisp;
			leftp = c1.localp;
			rightp = c2.localp;
			for (y=0; y<2; y++) {
				iy = 2-y;
				leftcol = (iy*c1.col + y*c3.col) >> 1;
				rightcol = (iy*c2.col + y*c4.col) >> 1;
				leftlight = (iy*c1.lightammount + y*c3.lightammount) >> 1;
				rightlight = (iy*c2.lightammount + y*c4.lightammount) >> 1;
				specleft = (iy*c1.specularcol + y*c3.specularcol) >> 1;
				specright = (iy*c2.specularcol + y*c4.specularcol) >> 1;
				ramp = (rightp-leftp)*0.5;
				thisp = leftp;
				for (x=0; x<2; x++) {
					ix = 2-x;
					lightammount = (ix*leftlight + x*rightlight) >> 1;
					if (c1.tex!=NULL) {
						col = GetTexCol(c1.objtype, thisp, c1.tex);
						thisp.x += ramp.x;
						thisp.y += ramp.y;
						thisp.z += ramp.z;
					} else col = (ix*leftcol + x*rightcol) >> 1;
					spec = (ix*specleft + x*specright) >> 1;
					col = ((col*lightammount)>>8) + spec;
					if (col > 255) col = 255;
					*buff = col;
					++buff;
				}
				if (c1.tex!=NULL) {
					leftp.x += rampleft.x;
					leftp.y += rampleft.y;
					leftp.z += rampleft.z;
					rightp.x += rampright.x;
					rightp.y += rampright.y;
					rightp.z += rampright.z;
				}
				buff += 320-2;
			}
		}
	}
}
void Trace4x4(const SVect3d &p, const SVect3d &d1, const SVect3d &d2,
			const SVect3d &d3, const SVect3d &d4,
			const SContactInfo &c1, const SContactInfo &c2,
			const SContactInfo &c3, const SContactInfo &c4,
			unsigned char *buff)
{
	int subdivision_needed = 0;

	if ((c1.uid!=c2.uid)||(c1.uid!=c3.uid)||(c1.uid!=c4.uid))
		subdivision_needed = 1;
	else {
		float avglight = (c1.lightammount + c2.lightammount + c3.lightammount + c4.lightammount)/4.0f;
		if (fabs(c1.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c2.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c3.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c4.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if ((c1.specularcol > SPEC_THRESH) && (c1.specularcol<250)) subdivision_needed = 1;
		else if ((c2.specularcol > SPEC_THRESH) && (c2.specularcol<250)) subdivision_needed = 1;
		else if ((c3.specularcol > SPEC_THRESH) && (c3.specularcol<250)) subdivision_needed = 1;
		else if ((c4.specularcol > SPEC_THRESH) && (c4.specularcol<250)) subdivision_needed = 1;
	}

//	subdivision_needed = 1;

	if (subdivision_needed) {
		// find d for top, bottom, left, right, and center
		SVect3d dtop = (d1+d2)/2.0f;
		SVect3d dbottom = (d3+d4)/2.0f;
		SVect3d dleft = (d1+d3)/2.0f;
		SVect3d dright = (d2+d4)/2.0f;
		SVect3d dcenter = (dleft+dright)/2.0f;
		// get contact info for each
		SContactInfo ctop, cbottom, cleft, cright, ccenter;
		GetContact(p, dtop, ctop);
		GetContact(p, dbottom, cbottom);
		GetContact(p, dleft, cleft);
		GetContact(p, dright, cright);
		GetContact(p, dcenter, ccenter);
		// pass along to Trace2x2
		Trace2x2(p, d1, dtop, dleft, dcenter, c1, ctop, cleft, ccenter, buff);
		Trace2x2(p, dtop, d2, dcenter, dright, ctop, c2, ccenter, cright, buff+2);
		Trace2x2(p, dleft, dcenter, d3, dbottom, cleft, ccenter, c3, cbottom, buff+640);
		Trace2x2(p, dcenter, dright, dbottom, d4, ccenter, cright, cbottom, c4, buff+642);

	} else {
		*buff = (c1.col*c1.lightammount) >> 8;
		if (!debugmode) {
			int x, y, ix, iy;
			SVect3d rampleft = (c3.localp-c1.localp)*0.25f;
			SVect3d rampright = (c4.localp-c2.localp)*0.25f;
			SVect3d ramp;
			unsigned int col;
			unsigned char leftcol, rightcol;
			unsigned char lightammount;
			unsigned char leftlight, rightlight;
			unsigned char specleft, specright, spec;
			SVect3d leftp, rightp, thisp;
			leftp = c1.localp;
			rightp = c2.localp;
			for (y=0; y<4; y++) {
				iy = 4-y;
				leftcol = (iy*c1.col + y*c3.col) >> 2;
				rightcol = (iy*c2.col + y*c4.col) >> 2;
				leftlight = (iy*c1.lightammount + y*c3.lightammount) >> 2;
				rightlight = (iy*c2.lightammount + y*c4.lightammount) >> 2;
				specleft = (iy*c1.specularcol + y*c3.specularcol) >> 2;
				specright = (iy*c2.specularcol + y*c4.specularcol) >> 2;
				ramp = (rightp-leftp)*0.25f;
				thisp = leftp;
				for (x=0; x<4; x++) {
					ix = 4-x;
					if (c1.tex!=NULL) {
						col = GetTexCol(c1.objtype, thisp, c1.tex);
						thisp.x += ramp.x;
						thisp.y += ramp.y;
						thisp.z += ramp.z;
					} else col = (ix*leftcol + x*rightcol) >> 2;
					lightammount = (ix*leftlight + x*rightlight) >> 2;
					spec = (ix*specleft + x*specright) >> 2;
					col = ((col*lightammount)>>8) + spec;
					if (col > 255) col = 255;
					*buff = col;
					++buff;
				}
				if (c1.tex!=NULL) {
					leftp.x += rampleft.x;
					leftp.y += rampleft.y;
					leftp.z += rampleft.z;
					rightp.x += rampright.x;
					rightp.y += rampright.y;
					rightp.z += rampright.z;
				}
				buff += 320-4;
			}
		}
	}
}



void Trace8x8(const SVect3d &p, const SVect3d &d1, const SVect3d &d2,
			const SVect3d &d3, const SVect3d &d4,
			const SContactInfo &c1, const SContactInfo &c2,
			const SContactInfo &c3, const SContactInfo &c4,
			unsigned char *buff)
{
	int subdivision_needed = 0;

	if ((c1.uid!=c2.uid)||(c1.uid!=c3.uid)||(c1.uid!=c4.uid))
		subdivision_needed = 1;
	else {
		float avglight = (c1.lightammount + c2.lightammount + c3.lightammount + c4.lightammount)/4.0f;
		if (fabs(c1.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c2.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c3.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if (fabs(c4.lightammount-avglight)>LIGHT_THRESH) subdivision_needed = 1;
		else if ((c1.specularcol > SPEC_THRESH) && (c1.specularcol<250)) subdivision_needed = 1;
		else if ((c2.specularcol > SPEC_THRESH) && (c2.specularcol<250)) subdivision_needed = 1;
		else if ((c3.specularcol > SPEC_THRESH) && (c3.specularcol<250)) subdivision_needed = 1;
		else if ((c4.specularcol > SPEC_THRESH) && (c4.specularcol<250)) subdivision_needed = 1;
	}

//	subdivision_needed = 1;

	if (subdivision_needed) {
		// find d for top, bottom, left, right, and center
		SVect3d dtop = (d1+d2)/2.0f;
		SVect3d dbottom = (d3+d4)/2.0f;
		SVect3d dleft = (d1+d3)/2.0f;
		SVect3d dright = (d2+d4)/2.0f;
		SVect3d dcenter = (dleft+dright)/2.0f;
		// get contact info for each
		SContactInfo ctop, cbottom, cleft, cright, ccenter;
		GetContact(p, dtop, ctop);
		GetContact(p, dbottom, cbottom);
		GetContact(p, dleft, cleft);
		GetContact(p, dright, cright);
		GetContact(p, dcenter, ccenter);
		// pass along to Trace4x4
		Trace4x4(p, d1, dtop, dleft, dcenter, c1, ctop, cleft, ccenter, buff);
		Trace4x4(p, dtop, d2, dcenter, dright, ctop, c2, ccenter, cright, buff+4);
		Trace4x4(p, dleft, dcenter, d3, dbottom, cleft, ccenter, c3, cbottom, buff+1280);
		Trace4x4(p, dcenter, dright, dbottom, d4, ccenter, cright, cbottom, c4, buff+1284);

	} else {
		*buff = (c1.col*c1.lightammount) >> 8;
		if (!debugmode) {
			int x, y, ix, iy;
			SVect3d rampleft = (c3.localp-c1.localp)*0.125f;
			SVect3d rampright = (c4.localp-c2.localp)*0.125f;
			SVect3d ramp;
			unsigned int col;
			unsigned char leftcol, rightcol;
			unsigned char lightammount;
			unsigned char leftlight, rightlight;
			unsigned char specleft, specright, spec;
			SVect3d leftp, rightp, thisp;
			leftp = c1.localp;
			rightp = c2.localp;
			for (y=0; y<8; y++) {
				iy = 8-y;
				leftcol = (iy*c1.col + y*c3.col) >> 3;
				rightcol = (iy*c2.col + y*c4.col) >> 3;
				leftlight = (iy*c1.lightammount + y*c3.lightammount) >> 3;
				rightlight = (iy*c2.lightammount + y*c4.lightammount) >> 3;
				specleft = (iy*c1.specularcol + y*c3.specularcol) >> 3;
				specright = (iy*c2.specularcol + y*c4.specularcol) >> 3;
				ramp = (rightp-leftp)*0.125;
				thisp = leftp;
				for (x=0; x<8; x++) {
					ix = 8-x;
					if (c1.tex!=NULL) {
						col = GetTexCol(c1.objtype, thisp, c1.tex);
						thisp.x += ramp.x;
						thisp.y += ramp.y;
						thisp.z += ramp.z;
					} else col = (ix*leftcol + x*rightcol) >> 3;
					lightammount = (ix*leftlight + x*rightlight) >> 3;
					spec = (ix*specleft + x*specright) >> 3;
					col = ((col*lightammount) >> 8) + spec;
					if (col > 255) col = 255;
					*buff = col;
					++buff;
				}
				buff += 320-8;
				if (c1.tex!=NULL) {
					leftp.x += rampleft.x;
					leftp.y += rampleft.y;
					leftp.z += rampleft.z;
					rightp.x += rampright.x;
					rightp.y += rampright.y;
					rightp.z += rampright.z;
				}
			}
		}
	}
}

void main()
{
	int x, y;
	unsigned int offs;
	float *sx = new float [321];
	float *sy = new float [201];
	float globalmat[16];
	float globalimat[16];
	float tempmat[16];
	float tempimat[16];

	int stillrunning = 1;
	char inchar;

	init_dither_tab();

	SContactInfo *thisrow = new SContactInfo[41];
	SContactInfo *nextrow = new SContactInfo[41];
	SVect3d *thisrowd = new SVect3d[41];
	SVect3d *nextrowd = new SVect3d[41];
	SContactInfo *rowswap;
	SVect3d *rowswapd;

	virt = new unsigned char far[64000];

	listing = new S3dObject*[num_objs];

	for (x=0; x<num_objs; x++) {
		listing[x] = new S3dObject;
		InitObject(listing[x]);
		listing[x]->uid = x+1;
	}

	listing[0]->objtype = UID_PLANE;
	Scale(4, 4, 4, listing[0]->mat);
	Translate(0, -1, 0, listing[0]->mat);
	//Rotate(0.5, 1, 0, 0, listing[0]->mat);
//	listing[0]->col = 200;
	listing[0]->tex = new STexture;
	LoadTexture("perlin.raw", 128, 128, listing[0]->tex);

	listing[1]->objtype = UID_SPHERE;
	Translate(1, 0, 0, listing[1]->mat);
	Rotate(1.75, 0, 1, 0, listing[1]->mat);
	listing[1]->col = 250;
	listing[1]->surface.z = 1.0f;
	listing[1]->tex = new STexture;
	LoadTexture("lovehina.raw", 128, 128, listing[1]->tex);

	listing[2]->objtype = UID_SPHERE;
	Translate(2, 0, 0, listing[2]->mat);
	listing[2]->col = 250;
	listing[2]->tex = listing[1]->tex;
	listing[2]->surface.z = 1.0f;

	for (x=0; x<num_objs; x++) {
		Invert(listing[x]->mat, listing[x]->imat);
	}

	for (x=0;x<321;x++) sx[x] = ((float)x-160.0)/200.0;
	for (y=0;y<201;y++) sy[y] = (100.0-(float)y)/200.0;

	myLight.pos.x = 10;
	myLight.pos.y = 20;
	myLight.pos.z = 10;

	SVect3d p, d;
	SContactInfo temp, contact;
	int i;

	float k = 0;

	setmode(0x13);
	greyscale();
	do {

	offs = 0;
	k += 0.025;

	LoadIdentity(globalmat);
	LoadIdentity(globalimat);
	Rotate(k, 0, 1, 0, globalmat);
	Rotate(0.5 + 0.5*sin(k*0.9), 1, 0, 0, globalmat);
	Translate(0, 0, -8.2 - 4*sin(k/1.78373), globalmat);
	Invert(globalmat, globalimat);

	clear(virt, 0);

	p.x = p.y = p.z = 0;
	p = Transform(p, globalimat);

	LoadIdentity(tempmat);
	Rotate(k*1.97, 0, 1, 0, tempmat);
	Translate(3, 0, 0, tempmat);
	Rotate(k*1.7f, 0, 0, 1, tempmat);
	Invert(tempmat, tempimat);
	_fmemcpy(listing[1]->mat, tempmat, 16*sizeof(float));
	_fmemcpy(listing[1]->imat, tempimat, 16*sizeof(float));

	LoadIdentity(tempmat);
	Translate(1, 0, 0, tempmat);
	Rotate(k*1.354, 1, 0, 0, tempmat);
	Invert(tempmat, tempimat);
	_fmemcpy(listing[2]->mat, tempmat, 16*sizeof(float));
	_fmemcpy(listing[2]->imat, tempimat, 16*sizeof(float));

	for (x=0;x<num_objs;x++) PrepFirstHit(listing[x], p);

	// set up row buffers
	for (x=0;x<41;x++) {
		d.x = sx[x*8];
		d.y = sy[5*8];
		d.z = -1.0f;
		d = Transform(d, globalimat) - p;
		thisrowd[x] = d;
		GetContact(p, d, contact);
		thisrow[x] = contact;

		d.x = sx[x*8];
		d.y = sy[6*8];
		d.z = -1.0f;
		d = Transform(d, globalimat) - p;
		nextrowd[x] = d;
		GetContact(p, d, contact);
		nextrow[x] = contact;
	}

	// render image
	for (y=5; y<20; y++) {
		for(x=0;x<40;x++) {
			offs = y*8*320 + x*8;
			Trace8x8(p, thisrowd[x], thisrowd[x+1], nextrowd[x], nextrowd[x+1],
					thisrow[x], thisrow[x+1], nextrow[x], nextrow[x+1], virt+offs);
		}
		// update next row
		rowswap = thisrow;
		thisrow = nextrow;
		nextrow = rowswap;
		rowswapd = thisrowd;
		thisrowd = nextrowd;
		nextrowd = rowswapd;
		for(x=0;x<41;x++) {
			d.x = sx[x*8];
			d.y = sy[y*8+16];
			d.z = -1.0f;
			d = Transform(d, globalimat) - p;
			nextrowd[x] = d;
			GetContact(p, d, contact);
			nextrow[x] = contact;
		}
	}

	dither(virt);
	waittrace();
	flip(virt);
	if (kbhit()) {
		inchar = getch();
		if(inchar == ' ') {
			debugmode = 1-debugmode;
		} else {
			stillrunning=0;
		}
	}

	} while (stillrunning);

	setmode(0x03);
}